/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.profiling.jvm.jfr;

import java.util.LinkedList;
import java.util.function.Supplier;
import jdk.jfr.FlightRecorder;
import mod.chiselsandbits.api.profiling.IProfilerResult;
import mod.chiselsandbits.profiling.CandBProfiler;
import mod.chiselsandbits.profiling.jvm.jfr.events.CandBProfilingFinishedEvent;
import mod.chiselsandbits.profiling.jvm.jfr.events.CandBProfilingSectionEvent;
import mod.chiselsandbits.profiling.jvm.jfr.events.CandBProfilingStartedEvent;
import mod.chiselsandbits.utils.StringUtils;
import net.minecraft.class_6506;
import net.minecraft.class_6611;

public class JfrCandBProfiler
extends CandBProfiler {
    private final ThreadLocal<LinkedList<CandBProfilingSectionEvent>> eventStack = ThreadLocal.withInitial(LinkedList::new);
    private final ThreadLocal<LinkedList<String>> nameStack = ThreadLocal.withInitial(LinkedList::new);

    public JfrCandBProfiler(class_6506 profilingEnvironment) {
        FlightRecorder.register(CandBProfilingStartedEvent.class);
        FlightRecorder.register(CandBProfilingFinishedEvent.class);
        FlightRecorder.register(CandBProfilingSectionEvent.class);
        if (!class_6611.field_34923.method_37984()) {
            class_6611.field_34923.method_37981(profilingEnvironment);
        }
        new CandBProfilingStartedEvent().commit();
    }

    @Override
    public void startSection(String name) {
        this.onNewSectionWith(name);
        super.startSection(name);
    }

    @Override
    public void startSection(Supplier<String> nameSupplier) {
        this.onNewSectionWith(nameSupplier.get());
        super.startSection(nameSupplier);
    }

    private void onNewSectionWith(String name) {
        this.nameStack.get().addFirst(name);
        String eventName = StringUtils.join(".", this.nameStack.get().descendingIterator());
        CandBProfilingSectionEvent event = new CandBProfilingSectionEvent(eventName);
        event.begin();
        this.eventStack.get().addFirst(event);
    }

    @Override
    public void endSection() {
        super.endSection();
        CandBProfilingSectionEvent event = this.eventStack.get().removeFirst();
        event.commit();
        this.nameStack.get().removeFirst();
    }

    @Override
    public IProfilerResult getResult() {
        new CandBProfilingFinishedEvent().commit();
        IProfilerResult result = super.getResult();
        new CandBProfilingStartedEvent().commit();
        return result;
    }

    @Override
    public IProfilerResult stop() {
        new CandBProfilingFinishedEvent().commit();
        IProfilerResult result = super.getResult();
        if (class_6611.field_34923.method_37984()) {
            class_6611.field_34923.method_37980();
        }
        return result;
    }
}

